log_rank_all_groups <- function(data){
  #create a new df to outout everything into
  new_df <- data.frame(matrix(ncol = 4, nrow = 0))
  names(new_df) <- c("condition1", "condition2", "chi_sq", "p")
  unique_groups <- unique(data$condition)
  #cycle through each unique condition, keeping technical replicates separate
  for(group1 in unique_groups){
    for(group2 in unique_groups){
      if(group1 != group2){
        condition1 = group1
        condition2 = group2
        group_data <- subset(data, condition %in% c(group1, group2))
        surv_diff <- survdiff(Surv(time, censored) ~ condition, data = group_data)
        pval <- 1 - pchisq(surv_diff$chisq, length(surv_diff$n) - 1)
        new_row <- c(condition1, condition2, surv_diff$chisq, pval)
        new_df[nrow(new_df) + 1,] <-new_row
      }
    }
  }
  return(new_df)
}